﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/bluetooth/bluetooth_AddressTypes.h>
#include <nn/bluetooth/bluetooth_Types.h>
#include <nn/btm/btm_Types.h>
#include <nn/xcd/xcd_Device.h>

namespace nn { namespace xcd { namespace detail{

template <typename TypeFrom>
inline ::nn::bluetooth::Address ConvertToCommonBluetoothAddress(const TypeFrom& address) NN_NOEXCEPT
{
    ::nn::bluetooth::Address outAddress;
    for (int i = 0; i < ::nn::bluetooth::AddressLength; i++)
    {
        outAddress.address[i] = address.address[i];
    }

    return outAddress;
}

template <typename T>
inline T ConvertFromCommonBluetoothAddress(const ::nn::bluetooth::Address& address) NN_NOEXCEPT
{
    T outAddress;
    for (int i = 0; i < ::nn::bluetooth::AddressLength; i++)
    {
        outAddress.address[i] = address.address[i];
    }

    return outAddress;
}


template <typename T>
inline bool IsSameBluetoothAddress(const T address1, const T address2) NN_NOEXCEPT
{
    bool result = true;
    for (int i = 0; i < 6; i++)
    {
        if (address1.address[i] == address2.address[i])
        {
        }
        else
        {
            result = false;
        }
    }
    return result;
}

template <typename T>
inline void ClearBluetoothAddress(T* address) NN_NOEXCEPT
{
    for (int i = 0; i < 6; i++)
    {
        address->address[i] = 0;
    }
}

inline bool IsNintendoGamepad(const nn::btm::BdName &name) NN_NOEXCEPT
{
    static const char joyName[] = "Joy-Con";
    static const char fullKeyName[] = "Pro Controller";
    static const char oldName[] = "NintendoGamepad";   // 候補互換担保

    if (0 == memcmp(name.name, joyName, strlen(joyName)) ||
        0 == memcmp(name.name, fullKeyName, strlen(fullKeyName)) ||
        0 == memcmp(name.name, oldName, strlen(oldName)))
    {
        return true;
    }

    return false;
}


}}} // namespace nn::xcd::detail
