﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Aardvark ラッパーライブラリの GPIO 機能の API 宣言です。
 */

#pragma once

#include <nn/nn_Common.h>

#include "aardvark_Types.win32.h"

namespace nn { namespace xcd { namespace detail { namespace aardvark {

/**
 * @name    GPIO の操作
 * @{
 */

int SetGpioDirection(DeviceHandle handle, nn::Bit8 pinMask) NN_NOEXCEPT;

int SetGpioPullup(DeviceHandle handle, nn::Bit8 pinMask) NN_NOEXCEPT;

int GetGpioPins(DeviceHandle handle) NN_NOEXCEPT;

int SetGpioPins(DeviceHandle handle, nn::Bit8 pins) NN_NOEXCEPT;

//! @}

}}}}
