﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <Windows.h>

#include "aardvark-os.win32.h"
#include "aardvark_Driver-os.win32.h"

namespace nn { namespace xcd { namespace detail { namespace aardvark {

namespace
{

// Driver クラスのインスタンスを取得
Driver& GetDriver() NN_NOEXCEPT
{
    return Driver::GetInstance();
}

}  // anonymous namespace

bool Initialize() NN_NOEXCEPT
{
    return GetDriver().Initialize();
}

bool IsInitialized() NN_NOEXCEPT
{
    return GetDriver().IsInitialized();
}

void Finalize() NN_NOEXCEPT
{
    GetDriver().Finalize();
}

DeviceHandle Open(int portNumber) NN_NOEXCEPT
{
    return GetDriver().Open(portNumber);
}

int Close(DeviceHandle handle) NN_NOEXCEPT
{
    return GetDriver().Close(handle);
}

int GetMode(DeviceHandle handle) NN_NOEXCEPT
{
    return GetDriver().GetConfig(handle);
}

int SetMode(DeviceHandle handle, Mode mode) NN_NOEXCEPT
{
    NN_SDK_ASSERT(mode != Mode_Query);

    return GetDriver().SetConfig(handle, mode);
}

int ConfigureSpi(DeviceHandle handle, const SpiConfig& config) NN_NOEXCEPT
{
    return GetDriver().ConfigureSpi(handle, config);
}

int SetSpiMode(DeviceHandle handle, SpiMode mode) NN_NOEXCEPT
{
    return GetDriver().SetSpiMode(handle, mode);
}

int SetSpiMasterSsPolarity(DeviceHandle handle, SpiMasterSsPolarity polarity) NN_NOEXCEPT
{
    return GetDriver().SetSpiMasterSsPolarity(handle, polarity);
}

int GetSpiBitrate(DeviceHandle handle) NN_NOEXCEPT
{
    return GetDriver().GetSpiBitrate(handle);
}

int SetSpiBitrate(DeviceHandle handle, int bitrateKhz) NN_NOEXCEPT
{
    NN_SDK_ASSERT(bitrateKhz > 0);

    return GetDriver().SetSpiBitrate(handle, bitrateKhz);
}

int ReadSpi(size_t* pOutDoneBytes, char* pOutReadData, size_t readDataBytes, DeviceHandle handle) NN_NOEXCEPT
{
    return GetDriver().ReadSpi(pOutDoneBytes, pOutReadData, readDataBytes, handle);
}

int WriteSpi(char* pOutReceiveData,
             const char* pWriteData,
             size_t transferBytes,
             DeviceHandle handle) NN_NOEXCEPT
{
    return GetDriver().WriteSpi(
        pOutReceiveData,
        transferBytes,
        pWriteData,
        transferBytes,
        handle);
}

int SetGpioDirection(DeviceHandle handle, ::nn::Bit8 pinMask) NN_NOEXCEPT
{
    return GetDriver().SetGpioDirection(handle, pinMask);
}

int SetGpioPullup(DeviceHandle handle, ::nn::Bit8 pinMask) NN_NOEXCEPT
{
    return GetDriver().SetGpioPullup(handle, pinMask);
}

int GetGpioPins(DeviceHandle handle) NN_NOEXCEPT
{
    return GetDriver().GetGpioPins(handle);
}

int SetGpioPins(DeviceHandle handle, ::nn::Bit8 pins) NN_NOEXCEPT
{
    return GetDriver().SetGpioPins(handle, pins);
}

}}}}
