﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_InitializeForSystemProcess.h"

#include "visrv_ProcessHeapBlockManager.h"
#include "visrv_MemoryManagement.h"
#include "visrv_ServerManager.h"
#include "native/visrv_BinderFunctions.h"
#include "native/visrv_SyncpointWaiter.h"
#include "vic/visrv_VicModule.h"
#include "vic/visrv_VicTaskWorker.h"
#include "master/visrv_Lib.h"
#include "client/visrv_LayerPool.h"
#include "client/visrv_PresentationTracerPool.h"
#include "indirect/visrv_IndirectDisplay.h"
#include "indirect/visrv_IndirectCopyImageMapDefer.h"
#include "indirect/visrv_IndirectFlipManager.h"
#include "fbshare/visrv_InitializeSharingServer.h"
#include "local/visrv_InitializeLocalServer.h"

namespace nn{ namespace visrv{

    void InitializeForSystemProcess() NN_NOEXCEPT
    {
        nn::visrv::g_ProcessHeapBlockManager.Initialize();
        nn::visrv::InitializeMemory();
        native::InterfaceDescriptor::Initialize();
        native::g_SyncpointWaiter.Initialize();
        master::Initialize();
        vic::g_VicModule.Initialize();
        vic::g_VicTaskWorker.Initialize();
        client::g_LayerPool.Initialize();
        client::g_PresentationTracerPool.Initialize(&g_ServerManager, MultiWaitIndex_PresentationTracerMin, MultiWaitIndex_PresentationTracerMax - MultiWaitIndex_IndirectMapCopyImageMin + 1);
        indirect::g_IndirectMapCopyImageContextTable.Initialize();
        indirect::g_IndirectDisplay.Initialize();
        indirect::g_IndirectFlipManager.Initialize();
        fbshare::InitializeSharingServer();
        g_ServerManager.Initialize();

        local::InitializeLocalServer(
            [](nn::os::MultiWaitHolderType* pHolder, void*) -> void
            {
                g_ServerManager.GetDisplayServerManager()->AddUserWaitHolder(pHolder);
            },
            [](nn::os::MultiWaitHolderType* pHolder, void*) -> void
            {
                nn::os::UnlinkMultiWaitHolder(pHolder);
            },
            nullptr,
            MultiWaitIndex_LocalRequestQueue
        );

    }

    void FinalizeForSystemProcess() NN_NOEXCEPT
    {
        g_ServerManager.Finalize();
        fbshare::FinalizeSharingServer();
        indirect::g_IndirectFlipManager.Finalize();
        indirect::g_IndirectDisplay.Finalize();
        indirect::g_IndirectMapCopyImageContextTable.Finalize();
        client::g_PresentationTracerPool.Finalize();
        client::g_LayerPool.Finalize();
        vic::g_VicTaskWorker.Finalize();
        vic::g_VicModule.Finalize();
        master::Finalize();
        native::g_SyncpointWaiter.Finalize();
        native::InterfaceDescriptor::Finalize();
        local::FinalizeLocalServer();
        nn::visrv::FinalizeMemory();
        nn::visrv::g_ProcessHeapBlockManager.Finalize();
    }

}}
