﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_VicModule.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/vi/vi_Result.h>

namespace nn{ namespace visrv{ namespace vic{
    VicModule g_VicModule;

    VicModule::VicModule() NN_NOEXCEPT
        : m_Device(nullptr)
        , m_pSession(nullptr)
    {
    }

    nn::Result VicModule::Initialize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());

        bool isSuccess = false;

        NN_RESULT_THROW_UNLESS(
            NvRmOpenNew(&m_Device) == NvSuccess,
            nn::vi::ResultOperationFailed()
        );
        NN_UTIL_SCOPE_EXIT{
            if(!isSuccess)
            {
                NvRmClose(m_Device);
                m_Device = nullptr;
            }
        };

        NN_RESULT_THROW_UNLESS(
            NvDdkVicCreateSession(m_Device, nullptr, &m_pSession) == NvSuccess,
            nn::vi::ResultOperationFailed()
        );
        NN_UTIL_SCOPE_EXIT{
            if(!isSuccess)
            {
                NvDdkVicFreeSession(m_pSession);
                m_pSession = nullptr;
            }
        };

        isSuccess = true;
        NN_RESULT_SUCCESS;
    }

    void VicModule::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        NvDdkVicFreeSession(m_pSession);
        NvRmClose(m_Device);
        m_pSession = nullptr;
        m_Device = nullptr;
    }

    bool VicModule::IsInitialized() const NN_NOEXCEPT
    {
        return m_Device != nullptr;
    }

    NvRmDeviceHandle VicModule::GetDevice() const NN_NOEXCEPT
    {
        return m_Device;
    }

    NvDdkVicSession* VicModule::GetSession() const NN_NOEXCEPT
    {
        return m_pSession;
    }

}}}
