﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nvrm_surface.h>
#include <nvgr.h>

#include "../visrv_VicImageFormat.h"

namespace nn{ namespace visrv{ namespace vic{ namespace detail{

    class VicImageFormatInfo
    {
    public:
        static NvColorFormat GetNvColorFormat(VicImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case VicImageFormat_Rgba8:
                return NvColorFormat_A8B8G8R8; // バイトオーダー的に逆になっている
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

        static NvRmSurfaceLayout GetNvRmSurfaceLayout(VicImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case VicImageFormat_Rgba8:
                return NvRmSurfaceLayout_Pitch;
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

        static int GetPixelSize(VicImageFormat format) NN_NOEXCEPT
        {
            switch(format)
            {
            case VicImageFormat_Rgba8:
                return 4;
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

    };

}}}}

