﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_PolicyLevel.h>
#include "../client/visrv_ClientConstants.h"

namespace nn{ namespace visrv{ namespace service{

    enum ServiceLevel
    {
        ServiceLevel_ApplicationDisplay,
        ServiceLevel_SystemDisplay,
        ServiceLevel_ManagerDisplay,
        ServiceLevel_Relay,
        ServiceLevel_IndirectDisplay,
    };

    bool CheckPolicyPermission(client::ClientPermission permission, nn::vi::PolicyLevelType policy) NN_NOEXCEPT;
    bool CheckServicePermission(client::ClientPermission permission, ServiceLevel service) NN_NOEXCEPT;

}}}
