﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "visrv_NativeType.h"

namespace nn{ namespace visrv{ namespace native{

    static const int BinderTransactionCodeBase = 1;

    enum IGraphicBufferProducerFunctionCode
    {
        IGraphicBufferProducerFunctionCode_RequestBuffer = BinderTransactionCodeBase,
        IGraphicBufferProducerFunctionCode_SetBufferCount,
        IGraphicBufferProducerFunctionCode_DequeueBuffer,
        IGraphicBufferProducerFunctionCode_DetachBuffer,
        IGraphicBufferProducerFunctionCode_DetachNextBuffer,
        IGraphicBufferProducerFunctionCode_AttachBuffer,
        IGraphicBufferProducerFunctionCode_QueueBuffer,
        IGraphicBufferProducerFunctionCode_CancelBuffer,
        IGraphicBufferProducerFunctionCode_Query,
        IGraphicBufferProducerFunctionCode_Connect,
        IGraphicBufferProducerFunctionCode_Disconnect,
        IGraphicBufferProducerFunctionCode_SetSidebandStream,
        IGraphicBufferProducerFunctionCode_AllocateBuffers,
        IGraphicBufferProducerFunctionCode_SetPreallocatedBuffer,
        IGraphicBufferProducerFunctionCode_GetBufferReleasedEvent,
    };

    class InterfaceDescriptor
    {
    public:
        static void Initialize() NN_NOEXCEPT;
        static void Finalize() NN_NOEXCEPT;

        static const android::String16& GetIGraphicBufferProducerDescriptor() NN_NOEXCEPT;
    };

}}}

