﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_BinderFunctions.h"

#include <new>
#include <utils/String16.h>
#include <binder/IBinder.h>

NN_STATIC_ASSERT(NN_ALIGNOF(android::String16) <= 8);

#define NN_VISRV_DEFINE_INTERFACE_DESCRIPTOR(name)  \
    NN_ALIGNAS(8) char g_ ## name ## DescriptorStorage[sizeof(android::String16)] = {}; \
    android::String16* g_p ## name ## Descriptor = nullptr;

#define NN_VISRV_INITIALIZE_INTERFACE_DESCRIPTOR(name,value)  \
    g_p ## name ## Descriptor = new(g_ ## name ## DescriptorStorage) android::String16(value);

#define NN_VISRV_FINALIZE_INTERFACE_DESCRIPTOR(name) \
    g_p ## name ## Descriptor->~String16(); \
    g_p ## name ## Descriptor = nullptr;


namespace nn{ namespace visrv{ namespace native{
    NN_STATIC_ASSERT(android::IBinder::FIRST_CALL_TRANSACTION == BinderTransactionCodeBase);

    namespace {
        NN_VISRV_DEFINE_INTERFACE_DESCRIPTOR(IGraphicBufferProducer);
    }

    void InterfaceDescriptor::Initialize() NN_NOEXCEPT
    {
        NN_VISRV_INITIALIZE_INTERFACE_DESCRIPTOR(IGraphicBufferProducer, "android.gui.IGraphicBufferProducer");
    }

    void InterfaceDescriptor::Finalize() NN_NOEXCEPT
    {
        NN_VISRV_FINALIZE_INTERFACE_DESCRIPTOR(IGraphicBufferProducer);
    }

    const android::String16& InterfaceDescriptor::GetIGraphicBufferProducerDescriptor() NN_NOEXCEPT
    {
        return *g_pIGraphicBufferProducerDescriptor;
    }

}}}
