﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/util/util_TypedStorage.h>
#include "visrv_Lib.h"
#include "detail/visrv_Common.h"
#include "detail/visrv_Globals.h"
#include "detail/visrv_DisplayManager.h"
#include "detail/visrv_PlatformDisplayDefines.h"
#include "detail/visrv_PlatformDisplayInfo.h"
#include "detail/visrv_Policies.h"
#include "detail/visrv_MemoryMap.h"
#include "detail/visrv_Lib.h"
#include "detail/visrv_Nvdc.h"
#include "../settings/visrv_Settings.h"

namespace nn{ namespace visrv{ namespace master{

    void Initialize() NN_NOEXCEPT
    {
        if( !detail::IsInitialized() )
        {
            settings::Initialize();
            nvdc::Initialize();

            detail::g_DisplayInfoSegmentCount[nn::vi::PolicyLevel_Standard] =
                detail::SetupStandardPolicy(
                    reinterpret_cast<detail::PlatformDisplayInfo*>(detail::g_DisplayInfoSegment[nn::vi::PolicyLevel_Standard]),
                    detail::DisplayInfoSegmentSize / sizeof(detail::PlatformDisplayInfo)
                );
            detail::g_DisplayInfoSegmentCount[nn::vi::PolicyLevel_Composition] =
                detail::SetupCompositionPolicy(
                    reinterpret_cast<detail::PlatformDisplayInfo*>(detail::g_DisplayInfoSegment[nn::vi::PolicyLevel_Composition]),
                    detail::DisplayInfoSegmentSize / sizeof(detail::PlatformDisplayInfo)
                );

            detail::PlatformDisplayInfo* displayListList[detail::PlatformDisplayCount] = {
                reinterpret_cast<detail::PlatformDisplayInfo*>(detail::g_DisplayInfoSegment[nn::vi::PolicyLevel_Standard]),
                reinterpret_cast<detail::PlatformDisplayInfo*>(detail::g_DisplayInfoSegment[nn::vi::PolicyLevel_Composition]),
            };
            int displayCountList[detail::PlatformDisplayCount] = {
                detail::g_DisplayInfoSegmentCount[nn::vi::PolicyLevel_Standard],
                detail::g_DisplayInfoSegmentCount[nn::vi::PolicyLevel_Composition],
            };

            detail::g_DisplayManager =
                new (&detail::g_DisplayManagerStorage) detail::DisplayManager(
                    detail::g_DisplaySegment,
                    detail::DisplaySegmentSize,
                    detail::g_LayerSegment,
                    detail::LayerSegmentSize,
                    displayListList,
                    displayCountList,
                    nn::vi::PolicyLevelCount
                );

            detail::Initialize();
        }
    }

    void Finalize() NN_NOEXCEPT
    {
        if( detail::IsInitialized() )
        {
            detail::Finalize();

            detail::g_DisplayManager->~DisplayManager();
            detail::g_DisplayManager = nullptr;

            nvdc::Finalize();
            settings::Finalize();
        }
    }

    void SetContentVisibility(bool isVisible) NN_NOEXCEPT
    {
        detail::g_DisplayManager->SetContentVisibility(isVisible);
    }

}}}
