﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/vi/vi_HotplugState.h>
#include <nn/vi/vi_RgbRange.h>
#include <nn/vi/vi_PowerState.h>
#include <nn/vi/vi_LayerStack.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/vi_CmuMode.h>
#include <nn/vi/vi_DisplayError.h>

namespace nn { namespace vi {
    struct DisplayModeInfo;
}}

namespace nn { namespace visrv { namespace master { namespace detail {

    class IModeFilter;

    class IPhysicalDisplay
    {
    public:
        explicit IPhysicalDisplay(const IModeFilter* pFilter) NN_NOEXCEPT;
        virtual ~IPhysicalDisplay() NN_NOEXCEPT;

        virtual nn::Result Open() NN_NOEXCEPT = 0;
        virtual void Close() NN_NOEXCEPT = 0;

        virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT = 0;
        virtual nn::Result GetMode(nn::vi::DisplayModeInfo* pOutMode) const NN_NOEXCEPT = 0;

        virtual int ListModes(nn::vi::DisplayModeInfo* pOutModes, int modeCountMax) const NN_NOEXCEPT = 0;

        virtual nn::Result SetMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT = 0;

        virtual int ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT = 0;
        virtual nn::Result GetRgbRange(nn::vi::RgbRangeType* pOutRange) const NN_NOEXCEPT = 0;
        virtual nn::Result SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT = 0;

        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT = 0;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT = 0;

        virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT = 0;

        virtual nn::Result GetPowerState(nn::vi::PowerStateType* pOutState) NN_NOEXCEPT = 0;
        virtual nn::Result SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT = 0;

        virtual nn::Result SetLayerStack(nn::vi::LayerStackType id) NN_NOEXCEPT = 0;
        virtual nn::Result GetLayerStack(nn::vi::LayerStackType* pOutId) const NN_NOEXCEPT = 0;

        virtual nn::Result SetCmuLuma(float luma) NN_NOEXCEPT = 0;
        virtual nn::Result GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT = 0;

        virtual bool IsHotplugEventSupported() const NN_NOEXCEPT = 0;
        virtual bool IsVsyncEventSupported() const NN_NOEXCEPT = 0;
        virtual bool IsModeChangedEventSupported() const NN_NOEXCEPT = 0;

        virtual nn::Result GetLogicalResolution(int* pOutWidth, int* pOutHeight) const NN_NOEXCEPT = 0;

        virtual nn::Result GetCmuMode(nn::vi::CmuModeType* pOutMode) const NN_NOEXCEPT = 0;
        virtual nn::Result SetCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT = 0;
        virtual nn::Result GetContrastRatio(float* pOutRatio) const NN_NOEXCEPT = 0;
        virtual nn::Result SetContrastRatio(float ratio) NN_NOEXCEPT = 0;
        virtual nn::Result GetGamma(float* pOutGamma) const NN_NOEXCEPT = 0;
        virtual nn::Result SetGamma(float gamma) NN_NOEXCEPT = 0;
        virtual nn::Result SetViewport(int x, int y, int width, int height) NN_NOEXCEPT = 0;
        virtual nn::Result GetCompositorErrorInfo(nn::vi::CompositorError* pOutErrorInfo, int* pOutLength, int errorID) NN_NOEXCEPT = 0;
    protected:
        const IModeFilter* pFilter;
    };

    int WriteCeFormatRgbRange(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax, bool isSelectable) NN_NOEXCEPT;

}}}}
