﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/edid.h>
#include <nn/settings/system/settings_Tv.h>
#include <nn/vi/vi_DisplayError.h>
#include "visrv_IPhysicalDisplay.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    class EdidDisplay : public IPhysicalDisplay
    {
    public:
        explicit EdidDisplay(const IModeFilter* pFilter) NN_NOEXCEPT;

        virtual nn::Result Open() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Close() NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetMode(nn::vi::DisplayModeInfo* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListModes(nn::vi::DisplayModeInfo* pOutModes, int modeCountMax) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetRgbRange(nn::vi::RgbRangeType* pOutRange) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetPowerState(nn::vi::PowerStateType* pOutState) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetLayerStack(nn::vi::LayerStackType id) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetLayerStack(nn::vi::LayerStackType* pOutId) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetCmuLuma(float luma) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT NN_OVERRIDE;

        virtual bool IsHotplugEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual bool IsVsyncEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual bool IsModeChangedEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetLogicalResolution(int* pOutWidth, int* pOutHeight) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetCmuMode(nn::vi::CmuModeType* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetContrastRatio(float* pOutRatio) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetContrastRatio(float ratio) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetGamma(float* pOutGamma) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetGamma(float gamma) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetViewport(int x, int y, int width, int height) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetCompositorErrorInfo(nn::vi::CompositorError* pOutErrorInfo, int* pOutLength, int errorID) NN_NOEXCEPT NN_OVERRIDE;
    private:
        nn::settings::system::Edid m_Data;
        nn::edid::Edid m_Handle;

        struct DisplayModeVisitorData
        {
            int writeCount;
            const IModeFilter* pFilter;
            nn::vi::DisplayModeInfo* pOutModes;
            int modeCountMax;
        };

        static bool DisplayModeVisitor(const nn::edid::DisplayModeInfo* pMode,
                                       const nn::edid::DisplayTimingInfo* pTimingInfo,
                                       const nn::edid::ImageSizeInfo* pSizeInfo,
                                       void* pUserData) NN_NOEXCEPT;
    };

}}}}
