﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include "../../visrv_Config.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    class DisplayPolicy
    {
    public:
        DisplayPolicy(bool hasLayerLimit,
                      int layerCountMax,
                      int zOrderCountMin,
                      int zOrderCountMax) NN_NOEXCEPT;

        bool HasLayerLimit() const NN_NOEXCEPT;
        int GetLayerCountMax() const NN_NOEXCEPT;

        int GetZOrderCountMin() const NN_NOEXCEPT;
        int GetZOrderCountMax() const NN_NOEXCEPT;
    private:
        int m_ZOrderCountMin;
        int m_ZOrderCountMax;
        int m_LayerCountMax;
        bool m_HasLayerLimit;
    };

}}}}
