﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/sf/vi_PolicyLevel.h>
#include "visrv_Allocator.h"
#include "../visrv_Display.h"
#include "visrv_WhitelistFilter.h"
#include "visrv_PlatformDisplayInfoSet.h"
#include "visrv_NullDisplay.h"
#include "visrv_DefaultDisplayStrategy.h"
#include "visrv_SingleDisplayStrategy.h"
#include "../../settings/visrv_DisplayController.h"
#include "visrv_Controller.h"

namespace nn { namespace visrv { namespace settings {
    class PlatformConfig;
}}}

namespace nn{ namespace visrv { namespace master{ namespace detail{

    class PlatformDisplayInfo;

    class DisplayFactory
    {
        NN_DISALLOW_COPY(DisplayFactory);
    public:
        DisplayFactory(void* startAddress, size_t size, const settings::PlatformConfig* pConfig) NN_NOEXCEPT;
        ~DisplayFactory() NN_NOEXCEPT;

        Display* Create(const PlatformDisplayInfoSet& infoSet, Display::Allocator* pAllocator, const char* name) NN_NOEXCEPT;
        void Destroy(Display* pDisplay) NN_NOEXCEPT;
    private:
        Allocator m_Allocator;

        Controller m_Controllers[settings::DisplayControllerCount];

        NullDisplay m_NullDisplay;

        SingleDisplayStrategy m_DefaultHighestPriority;
        DefaultDisplayStrategy m_DefaultPriorityFallback;

        SingleDisplayStrategy m_NullDisplayStrategy;

        const settings::PlatformConfig* m_pConfig;

        template <typename T>
        void* AllocateDisplay() NN_NOEXCEPT
        {
            void* ptr = m_Allocator.Allocate<T>();
            NN_SDK_ASSERT_NOT_NULL(ptr);

            return ptr;
        }
    };

}}}}
