﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../visrv_Display.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    class DefaultDisplay : public Display
    {
    public:
        DefaultDisplay(const detail::PlatformDisplayInfoSet& infoSet,
                       Allocator* pAllocator,
                       detail::IDisplayStrategy* strategy);

        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetLayerStack(nn::vi::LayerStackType id) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetLayerStack(nn::vi::LayerStackType* pOutId) const NN_NOEXCEPT NN_OVERRIDE;

        virtual bool IsHotplugEventSupported() const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT NN_OVERRIDE;

        virtual bool IsModeChangedEventSupported() const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetContrastRatio(float ratio) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetGamma(float* pOutGamma) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetGamma(float gamma) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetViewport(int x, int y, int width, int height) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetCompositorErrorInfo(nn::vi::CompositorError* pOutErrorInfo, int* pOutLength, int errorID) NN_NOEXCEPT NN_OVERRIDE;
    };

}}}}
