﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include "visrv_Controller.h"
#include "../../settings/visrv_InterfaceType.h"
#include "visrv_Allocator.h"
#include "visrv_NullDisplay.h"
#include "visrv_LcdDisplay.h"
#include "visrv_HdmiDisplay.h"
#include "visrv_DpDisplay.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    Controller::Controller(Allocator* pAllocator) NN_NOEXCEPT
        : m_pAllocator(pAllocator)
        , m_pDisplay(nullptr)
        , m_Edid(&m_Filter)
        , m_EdidStrategy(&m_Edid)
    {
        NN_SDK_ASSERT_NOT_NULL(m_pAllocator);
    }

    Controller::~Controller() NN_NOEXCEPT
    {
        if( m_pDisplay != nullptr )
        {
            m_pDisplay->Close();
            m_pDisplay->~IPhysicalDisplay();
            m_pAllocator->Free(m_pDisplay);
        }
    }

    void Controller::Initialize(settings::InterfaceType type, const nn::vi::DisplayModeInfoInternal* pModes, int modeCount) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_pDisplay == nullptr);

        switch( type )
        {
            case settings::InterfaceType::Null:
                m_pDisplay = new (m_pAllocator->Allocate<NullDisplay>()) NullDisplay();
                break;
            case settings::InterfaceType::Dsi:
                m_pDisplay = new (m_pAllocator->Allocate<LcdDisplay>()) LcdDisplay(&m_Filter);
                break;
            case settings::InterfaceType::Hdmi:
                m_pDisplay = new (m_pAllocator->Allocate<HdmiDisplay>()) HdmiDisplay(&m_Filter);
                break;
            case settings::InterfaceType::DisplayPort:
                m_pDisplay = new (m_pAllocator->Allocate<DpDisplay>()) DpDisplay(&m_Filter);
                break;
            default:
                NN_UNEXPECTED_DEFAULT;
        }

        NN_ABORT_UNLESS_RESULT_SUCCESS(m_pDisplay->Open());
        m_Strategy.Initialize(m_pDisplay);
        m_Filter.Initialize(pModes, modeCount);
    }

    IPhysicalDisplay* Controller::GetDisplay() NN_NOEXCEPT
    {
        return m_pDisplay;
    }

    IDisplayStrategy* Controller::GetStrategy() NN_NOEXCEPT
    {
        return &m_Strategy;
    }

    IPhysicalDisplay* Controller::GetEdid() NN_NOEXCEPT
    {
        return &m_Edid;
    }

    IDisplayStrategy* Controller::GetEdidStrategy() NN_NOEXCEPT
    {
        return &m_EdidStrategy;
    }

}}}}
