﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_IndirectProducerBinderTable.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>

namespace nn{ namespace visrv{ namespace indirect{
    const int IndirectProducerBinderTable::Size;

    IndirectProducerBinderTable::IndirectProducerBinderTable() NN_NOEXCEPT
    {
        std::memset(&m_EntryList[0], 0, sizeof(IndirectProducerBinderTableEntry) * Size);
    }

    nn::Result IndirectProducerBinderTable::Register(int* pOutEntryIndex, IndirectLayer* pLayer) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutEntryIndex);
        NN_SDK_REQUIRES_NOT_NULL(pLayer);

        for(int i = 0; i < Size; i++)
        {
            if(m_EntryList[i].pLayer == nullptr)
            {
                m_EntryList[i].pLayer = pLayer;
                *pOutEntryIndex = i;
                NN_RESULT_SUCCESS;
            }
        }

        NN_RESULT_THROW(nn::vi::ResultOperationFailed());
    }

    void IndirectProducerBinderTable::Unregister(int entryIndex) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(entryIndex, 0, Size);
        NN_SDK_REQUIRES_NOT_NULL(m_EntryList[entryIndex].pLayer);

        m_EntryList[entryIndex].pLayer = nullptr;
    }

    const IndirectProducerBinderTableEntry& IndirectProducerBinderTable::Get(int entryIndex) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(entryIndex, 0, Size);
        return m_EntryList[entryIndex];
    }

    nn::Result IndirectProducerBinderTable::Find(int* pOutEntryIndex, const IndirectLayer* pLayer) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pLayer);

        for(int i = 0; i < Size; i++)
        {
            if(m_EntryList[i].pLayer == pLayer)
            {
                *pOutEntryIndex = i;
                NN_RESULT_SUCCESS;
            }
        }
        NN_RESULT_THROW(nn::vi::ResultNotFound());
    }

}}}
