﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "visrv_IndirectLayer.h"

namespace nn{ namespace visrv{ namespace indirect{

    typedef int IndirectLayerIndex;

    class IndirectDisplay
    {
    public:
        static const int LayerCountMax = IndirectLayerCountMax;
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        IndirectLayer* GetLayer(IndirectLayerIndex index) NN_NOEXCEPT;

    private:
        bool m_IsInitialized;
        IndirectLayer m_LayerList[LayerCountMax];
    };

    extern IndirectDisplay g_IndirectDisplay;

}}}
