﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../visrv_Config.h"

namespace nn{ namespace visrv{ namespace fbshare{

    enum SharedBufferStaticStorageState
    {
        SharedBufferStaticStorageState_Free,
        SharedBufferStaticStorageState_Used,
    };

    class SharedBufferStaticStorage
    {
        NN_DISALLOW_COPY(SharedBufferStaticStorage);
        NN_DISALLOW_MOVE(SharedBufferStaticStorage);
    public:
        static const size_t Size = SharedBufferStaticStorageSize;

    public:
        SharedBufferStaticStorage() NN_NOEXCEPT;

        bool IsUsed(uint64_t key) const NN_NOEXCEPT;

        nn::Result AcquireStorage(void** pOutMemory, size_t* pOutSize, uint64_t key) NN_NOEXCEPT;

        // @pre IsUsed
        // @post !IsUsed
        void ReleaseStorage(void* pMemory, size_t size) NN_NOEXCEPT;

    private:
        SharedBufferStaticStorageState m_State;
    };

}}}
