﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SharedBufferPool.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/vi/vi_Result.h>

namespace nn{ namespace visrv{ namespace fbshare{

    nn::Result SharedBufferPool::Find(SharedBuffer** pOutValue, nn::vi::fbshare::SharedBufferHandle h) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(!h.IsInvalid(), nn::vi::ResultNotFound());

        SharedBuffer* p = nullptr;
        NN_RESULT_DO(FindImpl(&p, [h](const SharedBuffer& e){ return e.IsInitialized() && e.GetHandle() == h; }));
        *pOutValue = p;
        NN_RESULT_SUCCESS;
    }

}}}
