﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../visrv_Config.h"
#include "visrv_TArrayPool.h"
#include "visrv_SharedLowLevelLayer.h"

namespace nn{ namespace visrv{
    class ServerManager;
}}

namespace nn{ namespace visrv{ namespace fbshare{ namespace detail{

    class SharedLowLevelLayerManager
    {
    public:
        static const int Size = SharedLowLevelLayerCountMax;
        static const uintptr_t MultiWaitTagMin = MultiWaitIndex_SharedLowLevelLayerMin;
        static const uintptr_t MultiWaitTagMax = MultiWaitIndex_SharedLowLevelLayerMax;

    private:
        class SharedLowLevelLayerPool
            : public TArrayPool<SharedLowLevelLayer, Size>
        {
        };

    public:
        SharedLowLevelLayerManager() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result BindManagedLayer(
            SharedLowLevelLayer** pOutLayer,
            client::ClientObject* pClientObject,
            nn::vi::LayerId layerId,
            const char* displayName,
            nn::applet::AppletResourceUserId aruid
        ) NN_NOEXCEPT;

        nn::Result BindIndirectLayer(
            SharedLowLevelLayer** pOutLayer,
            client::ClientObject* pClientObject,
            nn::vi::IndirectProducerHandleType handle,
            nn::applet::AppletResourceUserId aruid
        ) NN_NOEXCEPT;

        void UnbindLayer(SharedLowLevelLayer* pLayer) NN_NOEXCEPT;

        void HandleMultiWait(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT;

    private:
        SharedLowLevelLayerPool m_LayerPool;

    };

}}}}
