﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/sf/sf_NativeHandleFwd.h>
#include "../visrv_Config.h"
#include "../native/detail/visrv_TransactionIGraphicBufferProducer.h"
#include "../native/visrv_SyncpointWaiter.h"
#include "../util/visrv_TQueue.h"
#include "../util/visrv_TResourcePool.h"

namespace nn{ namespace visrv{ namespace client{

    namespace detail
    {
        struct PresentationEntry
        {
            int32_t handle;
            uint32_t code;
            uint32_t flags;
            native::detail::TransactionIGraphicBufferProducer::QueueBufferRequest request;
        };

        class PresentationPreAcquireFenceWait
        {
        public:
            void Initialize(uintptr_t multiWaitTag) NN_NOEXCEPT;
            void Finalize() NN_NOEXCEPT;

            bool IsActive() const NN_NOEXCEPT;

            // function(arg)
            // コールバックが呼ばれた時点で !IsActive() になっている。
            void Activate(
                PresentationEntry* pEntry,
                void (*function)(PresentationEntry*, void*),
                void* arg
            ) NN_NOEXCEPT;

            // Active でない場合何もしない
            void Deactivate() NN_NOEXCEPT;

            void ProcessSignal(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked) NN_NOEXCEPT;

        private:
            native::SyncpointEntry      m_Entry;
            nn::os::MultiWaitHolderType m_Holder;
            PresentationEntry*          m_pPresentationEntry;
            void (*m_CallbackFunction)(PresentationEntry*, void*);
            void* m_CallbackUserPtr;
        };
    }

    class PresentationTracerPool;

    class PresentationTracer
    {
        friend class PresentationTracerPool;
    public:
        enum Mode
        {
            Mode_Idle,
            Mode_Recording,
            Mode_FenceWait,
        };

        typedef detail::PresentationEntry PresentationEntry;
        typedef util::TQueue<PresentationEntry, LayerPresentationQueueCapacity, false> PresentationRequestQueue;

    public:
        void Initialize(uintptr_t multiWaitTag) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void GetAllFencesExpiredEvent(nn::sf::NativeHandle& outHandle) NN_NOEXCEPT;

        void SetMode(Mode value) NN_NOEXCEPT;

        // !IsRecording() の場合何もしない。
        nn::Result RecordQueueBufferRequest(
            int32_t handle,
            uint32_t code,
            const void* requestBuffer,
            size_t requestBufferSize,
            uint32_t flags
        ) NN_NOEXCEPT;

    private:
        void ProcessMultiWaitSignalImpl(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked) NN_NOEXCEPT;

        PresentationEntry* FindPresentedEntryWithPendingPreAcquireFenceImpl() NN_NOEXCEPT;
        void UpdatePreAcquireFenceWaitStateImpl() NN_NOEXCEPT;

    private:
        Mode m_Mode = Mode_Idle;

        // Requests which are already sent to nvnvflinger.
        // entries are enqueued when QueueBuffer() is called, if Mode == Recording.
        PresentationRequestQueue m_RecordedPresentationQueue;

        detail::PresentationPreAcquireFenceWait m_PreAcquireFenceWait;

        // Mode == Waiting && Queue 中の全 fence が Expired の間シグナルする。
        nn::os::SystemEventType m_AllFencesExpiredEvent;
    };


}}}
