﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_Layer.h>
#include <nn/vi/vi_Result.h>
#include "vi_Display.h"
#include "vi_Layer.h"
#include "detail/vi_Common.h"
#include "../vi_Log.h"

nn::Result nn::vi::CreateLayer(Layer** pOutLayer, Display* pDisplay) NN_NOEXCEPT
{
    return CreateLayer(pOutLayer, pDisplay, 1280, 720);
}

nn::Result nn::vi::CreateLayer(Layer** pOutLayer, Display* pDisplay, int width, int height) NN_NOEXCEPT
{
    // Needs access to g_WindowManager
    std::lock_guard<nn::os::Mutex> lock(detail::GetInitializerLock());

    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutLayer);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    LayerSettings settings;
    nn::vi::SetLayerSettingsDefaults(&settings);

    return pDisplay->CreateLayer(pOutLayer, width, height, nn::vi::PixelFormat_Rgba8888, settings);
}

void nn::vi::DestroyLayer(Layer* pLayer) NN_NOEXCEPT
{
    // Needs access to g_WindowManager
    std::lock_guard<nn::os::Mutex> lock(detail::GetInitializerLock());

    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    pLayer->GetDisplay()->DestroyLayer(pLayer);
}

nn::Result nn::vi::SetLayerScalingMode(Layer* pLayer, ScalingMode mode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    return pLayer->SetScalingMode(mode);
}

nn::Result nn::vi::GetNativeWindow(NativeWindowHandle* pOutWindow, Layer* pLayer) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutWindow);
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    *pOutWindow = pLayer->GetNativeWindow();

    return nn::ResultSuccess();
}
