﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_DisplayConfig.h>
#include "detail/vi_Common.h"
#include "vi_Display.h"

nn::Result nn::vi::SetDisplayAlpha(Display* pDisplay, float alpha) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->SetAlpha(alpha);
}

nn::Result nn::vi::SetDisplayLayerStack(Display* pDisplay, LayerStack id) NN_NOEXCEPT
{
    NN_UNUSED(pDisplay);
    NN_UNUSED(id);

    return pDisplay->SetLayerStack(id);
}

nn::Result nn::vi::SetDisplayPowerState(Display* pDisplay, PowerState state) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    return pDisplay->SetPowerState(state);
}
