﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/hid/vi_Hid.h>
#include "../detail/vi_Common.h"
#include "../detail/vi_DisplayManager.h"
#include "../detail/vi_Globals.h"

int nn::vi::ListWindows(WindowInfo* pOutWindows, int windowCountMax) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(windowCountMax >= 0);

    std::lock_guard<nn::os::Mutex> initLock(detail::GetInitializerLock());

    if( !detail::IsInitialized() || pOutWindows == nullptr )
    {
        return 0;
    }

    int writeIndex = 0;

    std::lock_guard<nn::os::Mutex> displayLock(detail::g_DisplayManager->GetDisplayListLock());

    for( const Display& display : detail::g_DisplayManager->GetDisplayList() )
    {
        if( writeIndex >= windowCountMax )
        {
            break;
        }

        std::lock_guard<nn::os::Mutex> layerLock(display.GetLayerListLock());

        for( const Layer& layer : display.GetLayerList() )
        {
            if( writeIndex >= windowCountMax )
            {
                break;
            }

            pOutWindows[writeIndex].windowHandle = static_cast<HWND>(layer.GetNativeWindow());
            pOutWindows[writeIndex].isTouchscreen = display.GetInfo().IsTouchscreen();

            ++writeIndex;
        }
    }

    return writeIndex;
}
