﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include "vi_Windows.h"

namespace nn { namespace vi { namespace detail {

    class WindowManager
    {
    public:
        WindowManager() NN_NOEXCEPT;
        ~WindowManager() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        HWND CreateWindow(int width, int height, bool isTouchscreen) NN_NOEXCEPT;
        void DestroyWindow(HWND window) NN_NOEXCEPT;
    private:
        HWND m_Dispatcher;
        nn::os::Event m_DispatcherInitialized;

        HANDLE m_MessageThread;

        static DWORD WINAPI MessageThread(void* arg) NN_NOEXCEPT;
    };

}}}
