﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "vi_Allocator.h"
#include "../vi_Display.h"
#include "vi_WhitelistFilter.h"
#include "vi_WindowsDisplay.h"

namespace nn { namespace vi { namespace detail {

    class PlatformDisplayInfo;

    class DisplayFactory
    {
        NN_DISALLOW_COPY(DisplayFactory);
    public:
        DisplayFactory(void* startAddress, size_t size) NN_NOEXCEPT;

        Display* Create(const PlatformDisplayInfo& info, Display::Allocator* pAllocator) NN_NOEXCEPT;
        void Destroy(Display* pDisplay) NN_NOEXCEPT;
    private:
        Allocator m_Allocator;

        WindowsDisplay m_DefaultDisplay;
        WhiteListFilter m_DefaultDisplayFilter;

        template <typename T>
        void* AllocateDisplay() NN_NOEXCEPT
        {
            void* ptr = m_Allocator.Allocate<T>();
            NN_SDK_ASSERT_NOT_NULL(ptr);

            return ptr;
        }
    };

}}}
