﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "vi_DisplayFactory.h"
#include "vi_PlatformDisplayDefines.h"
#include "vi_PhysicalDisplayAdapter.h"

nn::vi::detail::DisplayFactory::DisplayFactory(void* startAddress, size_t size) NN_NOEXCEPT
    : m_Allocator(startAddress, size)
{
}

nn::vi::Display* nn::vi::detail::DisplayFactory::Create(const PlatformDisplayInfo& info, Display::Allocator* pAllocator) NN_NOEXCEPT
{
    Display* pDisplay = nullptr;

    if( std::strncmp(DefaultDisplayName, info.GetName(), DisplayInfo::NameLengthMax) == 0 )
    {
        m_DefaultDisplayFilter.Initialize(info.GetPolicy().GetValidModes(), info.GetPolicy().GetValidModeCount());
        pDisplay = new (AllocateDisplay<PhysicalDisplayAdapter>()) PhysicalDisplayAdapter(info, pAllocator, &m_DefaultDisplayFilter, &m_DefaultDisplay);
    }

    return pDisplay;
}

void nn::vi::detail::DisplayFactory::Destroy(Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pDisplay);
    pDisplay->~Display();
    m_Allocator.Free(pDisplay);
}
