﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_DisplayConfig.h>

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_StringUtil.h>

#include "vi_Config.h"
#include "vi_MemoryManagement.h"
#include "vi_CommonUtility.h"
#include "vi_DisplayUtility.h"
#include "vi_LayerUtility.h"

namespace nn{ namespace vi{

//--------------------------
// System API
//--------------------------

    nn::Result SetDisplayAlpha(Display* pDisplay, float alpha) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_MANAGER();
        return GetManagerService()->SetDisplayAlpha(GetDisplayIdWithValidation(pDisplay), alpha);
    }

    nn::Result SetDisplayLayerStack(Display* pDisplay, LayerStack id) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_MANAGER();
        return GetManagerService()->SetDisplayLayerStack(GetDisplayIdWithValidation(pDisplay), static_cast<LayerStackType>(id));
    }

    nn::Result SetDisplayPowerState(Display* pDisplay, PowerState state) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_MANAGER();
        return GetManagerService()->SetDisplayPowerState(GetDisplayIdWithValidation(pDisplay), static_cast<PowerStateType>(state));
    }

    nn::Result SetDefaultDisplay(Display* pDisplay) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_MANAGER();

        return GetManagerService()->SetDefaultDisplay(GetDisplayIdWithValidation(pDisplay));
    }

}}
