﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#define NN_VI_DRIVER_SERVICE_NAME "dispdrv"
#define NN_VI_DEFAULT_DISPLAY_NAME "Default"

namespace nn{ namespace vi{

    // @brief Max number of opened display
    static const int DisplayCountMax = 6;

    // @brief Max number of opened layer per display
    static const int LayerCountPerDisplayMax = 2;

    // @brief Max number of indirect layer
    static const int IndirectLayerCountMax = 8;

    // @brief Tag for application blocking ipc session
    static const int ApplicationBlockingIpcSessionTag = 1;

    // Values used for default layer size match that of EGL workaround
    // See NSBG-5822, NSBG-6281
    static const int LayerDefaultWidth = 1280;
    static const int LayerDefaultHeight = 720;

    static const bool EnableSharedFrameBufferCompression = true;

}}
