﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Cmu.h>

#include <algorithm>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>

#include "vi_Config.h"
#include "vi_MemoryManagement.h"
#include "vi_CommonUtility.h"
#include "vi_DisplayUtility.h"
#include "vi_LayerUtility.h"

namespace nn{ namespace vi{

//--------------------------
// System API
//--------------------------

    Result GetDisplayCmuMode(CmuMode* pOutMode, const Display* pDisplay) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        NN_SDK_REQUIRES_NOT_NULL(pOutMode);
        CmuModeType value = {};
        NN_RESULT_DO(GetSystemService()->GetDisplayCmuMode(&value, GetDisplayIdWithValidation(pDisplay)));
        *pOutMode = static_cast<CmuMode>(value);
        NN_RESULT_SUCCESS;
    }

    Result SetDisplayCmuMode(Display* pDisplay, CmuMode mode) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        return GetSystemService()->SetDisplayCmuMode(GetDisplayIdWithValidation(pDisplay), static_cast<CmuModeType>(mode));
    }

    Result GetDisplayContrastRatio(float* pOutRatio, const Display* pDisplay) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        NN_SDK_REQUIRES_NOT_NULL(pOutRatio);
        return GetSystemService()->GetDisplayContrastRatio(pOutRatio, GetDisplayIdWithValidation(pDisplay));
    }

    Result SetDisplayContrastRatio(Display* pDisplay, float ratio) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        return GetSystemService()->SetDisplayContrastRatio(GetDisplayIdWithValidation(pDisplay), ratio);
    }

    Result GetDisplayGamma(float* pOutGamma, const Display* pDisplay) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        NN_SDK_REQUIRES_NOT_NULL(pOutGamma);
        return GetSystemService()->GetDisplayGamma(pOutGamma, GetDisplayIdWithValidation(pDisplay));
    }

    Result SetDisplayGamma(Display* pDisplay, float ratio) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        return GetSystemService()->SetDisplayGamma(GetDisplayIdWithValidation(pDisplay), ratio);
    }

    Result SetDisplayCmuLuma(Display* pDisplay, float luma) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        return GetSystemService()->SetDisplayCmuLuma(GetDisplayIdWithValidation(pDisplay), luma);
    }

    Result GetDisplayCmuLuma(float* pOutLuma, const Display* pDisplay) NN_NOEXCEPT
    {
        NN_VI_REQUIRES_INITIALIZED_SYSTEM();
        return GetSystemService()->GetDisplayCmuLuma(pOutLuma, GetDisplayIdWithValidation(pDisplay));
    }

}}
