﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nvrm_surface.h>
#include <nvgr.h>
#include <nn/vi/buffer/vi_Buffer.h>

namespace nn{ namespace vi{ namespace buffer{

    struct BufferResource
    {
        static const int MaxBuffers = 3;

        buffer_handle_t            bufferHandle[MaxBuffers];
        alloc_device_t*            pAlloc;
        const gralloc_module_t*    pGrmodule;
        const hw_module_t*         pModule;
        NvRmMemHandle              memHandle[MaxBuffers];
        NvRmDeviceHandle           rmDeviceHandle;
        BufferInfo                 info;
        int                        syncFd;
        Layer*                     pLayer;
        void*                      pBuffer;
    };
}}}

