﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_HipcServer.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/usb/usb_PmTypes.h>
#include <nn/usb/usb_DiagTypes.h>

namespace nn {
namespace usb {
namespace pm {

class Pm;

class PmServiceImpl
{
public:
    explicit PmServiceImpl(Pm *pPm) NN_NOEXCEPT;
    ~PmServiceImpl() NN_NOEXCEPT;

    Result GetPowerEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetPowerState(nn::sf::OutBuffer state) NN_NOEXCEPT;

    Result GetDataEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetDataRole(nn::sf::Out<nn::usb::UsbDataRole> role) NN_NOEXCEPT;

    Result SetDiagData(DiagData data, uint32_t value) NN_NOEXCEPT;
    Result GetDiagData(DiagData data, nn::sf::Out<uint32_t> pOutValue) NN_NOEXCEPT;

private:
    Pm                     *m_pPm;
    nn::os::SystemEvent     m_PowerEvent;
    nn::os::SystemEvent     m_DataEvent;
};

} // end of namespace pm
} // end of namespace usb
} // end of namespace nn
