﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h>   // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>        // for nn::sf::ExpHeapStaticAllocator

#include "detail/usb_PdServiceName.h"    // for SfsmplCalculatorServiceName
#include "detail/usb_IPdCradleSession.h"    // for IPdCradleSession
#include "detail/usb_IPdCradleManager.h"    // for IPdCradleManager

#include "usb_PdCreateManager.h"

namespace nn { namespace usb { namespace pd {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreatePdCradleManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreatePdCradleManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<nn::usb::pd::detail::IPdCradleManager> CreatePdCradleManagerByHipc() NN_NOEXCEPT
{
    // PdServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IPdManager としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::usb::pd::detail::IPdCradleManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<nn::usb::pd::detail::IPdCradleManager, MyAllocator::Policy>(&ret, nn::usb::pd::detail::CradleServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

}}}
