﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include "usb_PdEventHolder.h"

namespace nn {
namespace usb {
namespace pd {
namespace driver {
namespace detail {

bool EventHolder::IsBoundEvent() NN_NOEXCEPT
{
    if (m_pEvent != nullptr)
    {
        return true;
    }
    return false;
}

void EventHolder::SignalEvent() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    if (m_pEvent)
    {
        nn::os::SignalSystemEvent(m_pEvent);
    }
}

void EventHolder::DestroyEvent() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    NN_SDK_ASSERT_NOT_NULL(m_pEvent);
    nn::os::DestroySystemEvent(m_pEvent);
    m_pEvent = nullptr;
}

void EventHolder::AttachEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> lock(m_EventHolderMutex);
    m_pEvent = pEvent;
}

} // detail
} // driver
} // pd
} // usb
} // nn
