﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief
 *
 * @details
 *
 *
 */

#pragma once

#include "usb_HsPrivateIncludes.h"

namespace nn { namespace usb { namespace hs {


class Hs
{
public:
    LocalEventManager    m_LocalEventManager;
    DeviceManager        m_DeviceManager;
    detail::UsbPlatform* m_pPlatform;
    PlatformController*  m_pController;

    Hs()
        : m_DeviceManager(this)
        , m_pPlatform(nullptr)
        , m_pController(nullptr)
        , m_MainThreadRun(false)
        , m_ServiceManager(this)
        , m_MessageQueue(m_MessageQueueStorage, MainThreadQueueLength)
        , m_StackMutex(true)
        , m_ClientsMutex(true)
    {
        memset(m_pClients, 0, sizeof(m_pClients));
    }
    ~Hs()
    {

    }

    // Top level host stack administration API
    Result Initialize(detail::UsbPlatform* pPlatform);
    Result Finalize();
    Result BindComplex(ComplexId complexId);
    Result UnbindComplex();

    // Methods used internally within host stack
    void SendDeferredRequest(uintptr_t message);
    nn::os::MessageQueue& GetRequestQueue();

    ClientId AllocateClientId(ClientRootSession* pClient);
    void FreeClientId(ClientId id);
    void AdvertiseDeviceInterfaceToClients(UsbDeviceDescriptor* pDeviceDescriptor,
                                           UsbInterfaceDescriptor* pInterfaceDescriptor);
    void LockStackMutex();
    void UnlockStackMutex();

private:
    static const int32_t MainThreadStackSize = 1024 * 64;
    static const int32_t MainThreadQueueLength = 32;

    enum MainThreadPort
    {
        MainThreadPort_ReEvaluate = 0,
        MainThreadPort_LocalEventTimer,
        MainThreadPort_Message,
        MainThreadPort_MaxPorts,
    };

    bool                            m_MainThreadRun;
    ServiceManager                  m_ServiceManager;
    nn::os::ThreadType              m_MainThread;
    uintptr_t                       m_MessageQueueStorage[MainThreadQueueLength];
    nn::os::MessageQueue            m_MessageQueue;
    nn::os::Mutex                   m_StackMutex;
    NN_OS_ALIGNAS_THREAD_STACK char m_MainThreadStack[MainThreadStackSize];
    static void MainThreadEntry(void* pThis) { ((Hs *)pThis)->MainThread();}
    nn::os::MultiWaitType           m_MultiWait;
    nn::os::MultiWaitHolderType     m_Holder[MainThreadPort_MaxPorts];
    nn::os::EventType               m_ReEvaluateEvent;

    // List of active clients, protected by mutex
    ClientRootSession*              m_pClients[HsLimitMaxClientCount];
    nn::os::Mutex                   m_ClientsMutex;

    Result DispatchDeferred(DeferredRequestBase *pDeferredRequestBase);
    void MainThread();
};


} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

