﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*
 * @file    usb_DsDummyController.h
 * @brief   Dummy Device Controller
 */

#include "usb_DsController.h"

namespace nn {
namespace usb {
namespace ds {

class DsDummyController : public DsController
{
public:
    DsDummyController() NN_NOEXCEPT
        : DsController(0)
    {
        // do nothing
    }

    ~DsDummyController() NN_NOEXCEPT
    {
        // do nothing
    }

    virtual Result Initialize(detail::UsbComplex* pComplex,
                              detail::UsbController::Config* pConfig) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Finalize() NN_NOEXCEPT NN_OVERRIDE;

    virtual Result Enable() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Disable() NN_NOEXCEPT NN_OVERRIDE;

    // device functions
    virtual Result Attach() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Detach() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Ctrl(UsbCtrlRequest *pCtrl) NN_NOEXCEPT NN_OVERRIDE;
    virtual UsbDeviceSpeed GetConnectSpeed() NN_NOEXCEPT NN_OVERRIDE;

    // endpoint functions
    virtual Result EnableEndpoint(UsbEndpointDescriptor *pUsbEndpointDescriptor, UsbEndpointCompanionDescriptor *pUsbEndpointCompanionDescriptor) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DisableEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result FlushEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result StallEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result SetZlt(uint8_t bEndpointAddress, bool zlt) NN_NOEXCEPT NN_OVERRIDE;
};

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
