﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//#define NN_USB_ENABLE_TRACE
#include "usb_DsDummyController.h"

namespace nn {
namespace usb {
namespace ds {

#undef  NN_USB_TRACE_CLASS_NAME
#define NN_USB_TRACE_CLASS_NAME "DsDummyController"

//----------------------------------------------------------------------------
//  public functions
//----------------------------------------------------------------------------

Result DsDummyController::Initialize(detail::UsbComplex* pComplex,
                                     detail::UsbController::Config* pConfig) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(pComplex);
    NN_UNUSED(pConfig);

    return ResultResourceBusy();
}

Result DsDummyController::Finalize() NN_NOEXCEPT
{
    NN_USB_TRACE;
    return ResultResourceBusy();
}

Result DsDummyController::Enable() NN_NOEXCEPT
{
    NN_USB_TRACE;
    return ResultResourceBusy();
}

Result DsDummyController::Disable() NN_NOEXCEPT
{
    NN_USB_TRACE;
    return ResultResourceBusy();
}

Result DsDummyController::Attach() NN_NOEXCEPT
{
    NN_USB_TRACE;
    return ResultResourceBusy();
}

Result DsDummyController::Detach() NN_NOEXCEPT
{
    NN_USB_TRACE;
    return ResultResourceBusy();
}

Result DsDummyController::Ctrl(UsbCtrlRequest *pCtrl) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(pCtrl);
    return ResultResourceBusy();
}

UsbDeviceSpeed DsDummyController::GetConnectSpeed() NN_NOEXCEPT
{
    return UsbDeviceSpeed_Invalid;
}

Result DsDummyController::EnableEndpoint(UsbEndpointDescriptor *pUsbEndpointDescriptor, UsbEndpointCompanionDescriptor *pUsbEndpointCompanionDescriptor) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(pUsbEndpointDescriptor);
    NN_UNUSED(pUsbEndpointCompanionDescriptor);
    return ResultResourceBusy();
}

Result DsDummyController::DisableEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(bEndpointAddress);
    return ResultResourceBusy();
}

Result DsDummyController::FlushEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(bEndpointAddress);
    return ResultResourceBusy();
}

Result DsDummyController::StallEndpoint(uint8_t bEndpointAddress) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(bEndpointAddress);
    return ResultResourceBusy();
}

Result DsDummyController::SetZlt(uint8_t bEndpointAddress, bool zlt) NN_NOEXCEPT
{
    NN_USB_TRACE;
    NN_UNUSED(bEndpointAddress);
    NN_UNUSED(zlt);
    return ResultResourceBusy();
}

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn
