﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "usb_DsController.h"

namespace nn {
namespace usb {
namespace ds {

//----------------------------------------------------------------------------
//  Public Methods
//----------------------------------------------------------------------------

Result DsController::Initialize(detail::UsbComplex *pComplex, detail::UsbController::Config* pConfig) NN_NOEXCEPT
{
    Result result = detail::UsbController::Initialize(pComplex, pConfig);

    if (result.IsSuccess())
    {
        result = protocol.Initialize();
    }
    else
    {
        NN_USB_LOG_INFO("DsController::%s(@%d) result %d\n",__FUNCTION__,__LINE__, result.GetDescription()); \
    }

    return result;
}

Result DsController::Finalize() NN_NOEXCEPT
{
    Result result = protocol.Finalize();

    if (result.IsSuccess())
    {
        result = detail::UsbController::Finalize();
    }

    return result;
}

} // end of namespace ds
} // end of namespace usb
} // end of namespace nn

