﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_DsCommon.h
 * @brief   USB Device Stack Common Header
 */

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Assert.h>

#include <nn/os.h>
#include <nn/os/os_SdkThreadCommon.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/sf/sf_HipcServer.h>

#include <nn/usb/usb_Limits.h>
#include <nn/usb/usb_ResultPrivate.h>
#include <nn/usb/usb_DeviceTypes.h>
#include <nn/usb/ds/sfdl/usb_IDsService.sfdl.h>
#include <nn/usb/ds/sfdl/usb_IDsInterface.sfdl.h>
#include <nn/usb/ds/sfdl/usb_IDsEndpoint.sfdl.h>

#include "../detail/usb_Memory.h"
#include "../detail/usb_Util.h"
#include "../detail/usb_IoVaManager.h"
