﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_PlatformNx.h
 * @brief   Nx Platform Abstraction
 */

#include "usb_Platform.h"
#include "usb_ComplexTegra21x.h"

namespace nn {
namespace usb {
namespace detail {

class UsbPlatformNx : public UsbPlatform
{
public:
    virtual Result      Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result      Finalize() NN_NOEXCEPT NN_OVERRIDE;

private:
    UsbComplexTegra21x  m_Tegra21x;
};

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn
