﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Memory allocator
 *
 * @details This module provides basic memory allocation
 */

#include <nn/sf/sf_ExpHeapAllocator.h>

namespace nn { namespace usb { namespace detail {

void UsbMemoryInit();
void UsbMemoryFinalize();

nn::sf::ExpHeapAllocator* UsbMemoryGetAllocator();

void* UsbMemoryAlloc(size_t size);
void* UsbMemoryAlloc(size_t size, const char *objectname);

void* UsbMemoryAllocAligned(size_t size, size_t alignment);
void* UsbMemoryAllocAligned(size_t size, size_t alignment, const char *objectname);

void* UsbMemoryCalloc(size_t size, const char *objectName);
void* UsbMemoryCallocAligned(size_t size, size_t alignment, const char *objectName);

void* UsbMemoryRealloc(void* addr, size_t newSize);
void* UsbMemoryRealloc(void* addr, size_t newSize, const char *objectname);

void* UsbMemoryReallocAligned(void* addr, size_t newSize, size_t alignment);
void* UsbMemoryReallocAligned(void* addr, size_t newSize, size_t alignment, const char *objectname);

void  UsbMemoryFree(void *pMem);
void  UsbMemoryFree(void *pMem, const char *objectName);

size_t UsbMemoryGetTotalFreeSize();

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn

