﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace updater {

const size_t   BctSize = 0x4000;
const size_t   EksSize = 0x4000;
const size_t   EksEntrySize = 0x200;
const size_t   CopyEksSize = 0xB0;

struct BctBuffer
{
    char eks[EksSize];
    char bct[BctSize];
};

Result ReadFile(size_t* outSize, char* buffer, size_t bufferSize, const char* path) NN_NOEXCEPT;

Result ReadFileAndCalculateHash(size_t* pOutSize, void* pOutHash, size_t hashSize, const char* path, void* workBuffer, size_t bufferSize) NN_NOEXCEPT;

Result VerifyBuffer(void* workBuffer, size_t size) NN_NOEXCEPT;
}}
