﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "uart_TargetSpec.h"

namespace nn {
namespace uart {
namespace driver {
namespace detail {

/**
 * @brief   各 UART のレジスタ定義
 */
const UartRegisterDefs UartRegisterTable[PortCountMax] =
{
    // UART A
    {
        0x000       // UART
    },
    // UART B
    {
        0x040       // UART
    },
    // UART C
    {
        0x200       // UART
    },
    // UART D
    {
        0x300       // UART
    }
};

#ifndef NN_BUILD_CONFIG_SPEC_NX
/**
 * @brief   CLK_RST のレジスタ定義
 */
const ClkRstRegisterDefs ClkRstRegisterTable[PortCountMax] =
{
    // UART A
    {
        0x178,      // Clock source
        0x010,      // Clock enable
        0x004,      // Reset
        1 << 6,     // Clock enable bit mask
        1 << 6      // Reset bit mask
    },
    // UART B
    {
        0x17c,      // Clock source
        0x010,      // Clock enable
        0x004,      // Reset
        1 << 7,     // Clock enable bit mask
        1 << 7      // Reset bit mask
    },
    // UART C
    {
        0x1a0,      // Clock source
        0x014,      // Clock enable
        0x008,      // Reset
        1 << 23,    // Clock enable bit mask
        1 << 23     // Reset bit mask
    },
    // UART D
    {
        0x1c0,      // Clock source
        0x018,      // Clock enable
        0x00c,      // Reset
        1 << 1,     // Clock enable bit mask
        1 << 1      // Reset bit mask
    }
};

/**
 * @brief CLK_RST レジスタの CLK_M の指定値
 */
enum ClkRstRegisterSource
{
    ClkRstRegisterSource_PllPOut0   = 0, //!< PLLP_OUT0
    ClkRstRegisterSource_PllC2Out0  = 1, //!< PLLC2_OUT0
    ClkRstRegisterSource_PllCOut0   = 2, //!< PLLC_OUT0
    ClkRstRegisterSource_PllC4Out0  = 3, //!< PLLC4_OUT0
    ClkRstRegisterSource_PllC4Out1  = 5, //!< PLLC4_OUT1
    ClkRstRegisterSource_ClkM       = 6, //!< CLK_M
    ClkRstRegisterSource_PllC4Out2  = 7  //!< PLLC4_OUT2
};

#endif

} // detail
} // driver
} // uart
} // nn
