﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "uart_TargetSpec-hardware.jetson-tk1.h"

namespace nn {
namespace uart {
namespace driver {
namespace detail {

/**
 * @brief   各 UART のレジスタ定義
 */
const UartRegisterDefs UartRegisterTable[PortCountMax] =
{
#if 1
    // UART B/VFIR
    {
        0x040       // UART
    }
#else
    // 初期の動作確認用。こちらを使用する場合、カーネル / SDK ログが同ポートを使っているのを切る改造が必要
    // UART D
    {
        0x300       // UART
    }
#endif
};

/**
 * @brief   CLK_RST のレジスタ定義
 */
const ClkRstRegisterDefs ClkRstRegisterTable[PortCountMax] =
{
#if 1
    // UART B/VFIR
    {
        0x17c,      // Clock source
        0x010,      // Clock enable
        0x004,      // Reset
        1 << 7,     // Clock enable bit mask
        1 << 7      // Reset bit mask
    }
#else
    // 初期の動作確認用。こちらを使用する場合、カーネル / SDK ログが同ポートを使っているのを切る改造が必要
    // UART D
    {
        0x1c0,      // Clock source
        0x018,      // Clock enable
        0x00c,      // Reset
        1 << 1,     // Clock enable bit mask
        1 << 1      // Reset bit mask
    }
#endif
};

/**
 * @brief CLK_RST レジスタの CLK_M の指定値 ([Ref1] 5.2.76 etc)
 */
enum ClkRstRegisterSource
{
    ClkRstRegisterSource_PllPOut0   = 0, //!< PLLP_OUT0
    ClkRstRegisterSource_PllC2Out0  = 1, //!< PLLC2_OUT0
    ClkRstRegisterSource_PllCOut0   = 2, //!< PLLC_OUT0
    ClkRstRegisterSource_PllC3Out0  = 3, //!< PLLC3_OUT0
    ClkRstRegisterSource_PllMOut0   = 4, //!< PLLM_OUT0
    ClkRstRegisterSource_ClkM       = 6  //!< CLK_M
};

} // detail
} // driver
} // uart
} // nn
