﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

// From: ./sdk/Programs/Alice/Include/nn/detail/nn_Macro-compiler.clang.h
#define NN_ALIGNAS( alignment ) __attribute__((aligned(alignment)))
// From: ./sdk/Programs/Chris/Include/nn/os/os_ThreadCommon.h
#define NN_OS_ALIGNAS_THREAD_STACK  NN_ALIGNAS(4096)

#include "tmipc_thread.h"
#include "tmipc_result.h"
#include <HotBridgeAPI.h>

//==============================================================================
namespace tmipc {
//==============================================================================

namespace
{
    class TicsBridgeInstance;
}

class Packet;

// This class initializes the internal TICS system and creates a TICS thread
// for a single "session" (one connection).

// A wrapper class for the Tics "target" app.
class TICSInterface
{
private:

static  Thread* m_pSessionThread;
static  Mutex*  m_pReceiveMutex;
static  Mutex*  m_pSendMutex;
static  Event*  m_pStartedEvent;
static  Event*  m_pConfigEvent;
static  bool    m_bStopSession;

    // The TICS thread.
static s32              SessionThread( void* lpNull );


private:
// --------------------------------------------------------------------------
// NOTE:    The following functions are meant for internal purposes only.
//          Do *not* call them directly.  Used by TicsBridgeInstance.
// --------------------------------------------------------------------------
    friend TicsBridgeInstance;

    // Called by TicsBridgeInstance, when a session has started.
static void             SessionStartedCallback( void* lpNull );

public:

    // Initialize the TICS interface.
static  tmipc::Result   Initialize();

    // Finalize the TICS wrapper.
static  tmipc::Result   Finalize();

    // Directly toggle the status LEDs, Cradle indicator, etc...
static  tmipc::Result   SetTargetStatusFlag( tics::ETargetStatusFlag Flag, bool State );

    //
static  tmipc::Result   ConfigSectionAttrGet( const char* sectionName, const char *attrName, char *attrValue, int attrValueLen );

    // Starts the TICS session.
static  tmipc::Result   StartSession( int ThreadPriority );

    // Stops a single TICS session.
static  tmipc::Result   StopSession();

    // Hack: Notifies the TICS session to end.  Allows internal data to be
    //       cleaned up.
static tmipc::Result    CleanupSession();

    // Reads data from the TICS connection.
    // Returns: TMIPC_RESULT_OK: success; non-TMIPC_RESULT_OK: an error occurred.
static  tmipc::Result   Read( tmipc::Packet& Packet );

    // Writes data to the TICS connection.
    // Returns: TMIPC_RESULT_OK: success; non-TMIPC_RESULT_OK: an error occurred.
static  tmipc::Result   Write( const tmipc::Packet& Packet );

    // Sends a Beacon request back to the remote connection.
static  tmipc::Result   SendBeaconPacket( tmipc::Packet& Packet );
};

//==============================================================================
}
//==============================================================================
