﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
namespace tmapi {
//------------------------------------------------------------------------------

//==============================================================================
//  result
//==============================================================================

enum result : int32_t
{
    RESULT_OK,                                  // All good.

    RESULT_GENERIC_RANGE_BEGIN                  = 1,
    RESULT_UNKNOWN,                             // Unknown error.
    RESULT_TIMEOUT,                             // Timeout.
    RESULT_NO_CONNECTION,                       // No connection to Target Manager service.
    RESULT_INCOMPATIBLE_PROTOCOL,               // TM protocol version incompatible.
    RESULT_INVALID_OPCODE,                      // Invalid protocol opcode.
    RESULT_TARGET_BUSY,                         // The requested target is busy. CMD_SET_TARGET.
    RESULT_TARGET_UNAVAILABLE,                  // Active target no longer available.
    RESULT_INVALID_ADDRESS,                     // Invalid memory address.
    RESULT_EXECUTABLE_NOT_FOUND,                // Requested executable file was not found.
    RESULT_INVALID_TARGET,                      // Invalid target specified.
    RESULT_INVALID_PROCESS,                     // Invalid process specified.
    RESULT_INVALID_RESPONSE,                    // Invalid value returned.
    RESULT_TARGET_DUPLICATED,                   // Target already exists.
    RESULT_INVALID_PARAMETER,                   // One of the parameter(s) is invalid.
    RESULT_INVALID_DEVICE_HANDLE,               // The HID handle is invalid.
    RESULT_INVALID_CONTROLLER,                  // The controller index is invalid.
    RESULT_EXECUTABLE_NOT_COMPATIBLE,           // The executable file is not compatible with the hardware.
    RESULT_BUFFER_TOO_SMALL,                    // A provided buffer is too small.
    RESULT_INTERNAL_ERROR,                      // An "internal error" occurred.
    RESULT_CANCELLED,                           // Cancelled
    RESULT_CONNECT_VERSION_ERROR,               // Incorrect version connection problem
    RESULT_CONNECT_FAILED,                      // Generic failure.  Hopefully we know more than this.
    RESULT_NOT_IMPLEMENTED,                     // An API or feature is not implemented.
    RESULT_INCOMPATIBLE_TMAPI_VERSION,          // The Client and Target Manager TMAPI versions are not compatible.
    RESULT_DEBUGGING_UNAVAILABLE,               // Debugging service isn't available.
    RESULT_NOT_BACKWARDS_COMPATIBLE,            // The packet failed to send because the specified task is not backwards compatible an older target, i.e. the target is not up to date with this version of target manager.
    RESULT_SERVICE_UNAVAILABLE,                 // The service that handles this isn't available.
    RESULT_TARGET_DISCOVERY_ALREADY_STARTED,    // Target discovery has already started.
    RESULT_CONNECT_FAILED_LOGSERVER,            // The connect failed because LogServer is unavailable
    RESULT_TARGET_IO_SEARCH_COMPLETE,           // The target IO search is finished, we have found all there is to find.
    RESULT_TARGET_IO_INSUFFICIENT_SPACE,        // Not enough space on the memory card.
    RESULT_TARGET_IO_NO_MEMORY_CARD,            // No memory card inserted in the device.
    RESULT_TARGET_IO_PATH_ALREADY_EXISTS,       // Path already exists on the memory card.
    RESULT_TARGET_IO_MEMORY_CARD_ERROR,         // Problem reading the memory card.
    RESULT_TARGET_ASLEEP,                       // Target is asleep.
    RESULT_NO_PROCESS_LOADED,                   // No process is loaded on the target.
    RESULT_INCOMPATIBLE_TARGET_MANAGER,         // This function is not implemented in the detected version of Target Manager. This can occur if client code is attempting to call a new function on an older version of Targer Manager.
    RESULT_TARGET_NOT_CONNECTED,                // Requested action requires a connection to the target.

    // Coredump results
    RESULT_COREDUMP_UNABLE_TO_CREATE,              // Unable to create coredump file.
    RESULT_COREDUMP_NOT_IN_PROGRESS,               // No Coredump in progress.
    RESULT_COREDUMP_FAILED,                        // Coredump failed.
    RESULT_COREDUMP_CANCELLED,                     // Coredump cancelled by the user.

    RESULT_INVALID_HTCS_ADDRESS,                   // An invalid HTCS address was requested. HTCS addresses must be of the form "xxx.xxx.xxx.xxx:yyyyy".
    RESULT_DUPLICATE_HTCS_ADDRESS,                 // An HTCS reservation was requested that conflicts with an existing HTCS reservation with the same ip address and port number or the same server and port names.
    RESULT_HTCS_ADDRESS_NOT_FOUND,                 // No HTCS entry exists with the specified address.
    RESULT_OTHER_USER,                             // The target is in use by another user.
    RESULT_INVALID_SCREENSHOT_FOLDER_SETTING,      // Invalid screenshot folder setting. Check your screenshot settings in Options.
    RESULT_INVALID_SCREENSHOT_FILENAME_SETTING,    // Invalid screenshot filename setting. Check your screenshot settings in Options.
    RESULT_HTCS_ENTRY_NOT_FOUND,                   // No HTCS entry exists with the specified peer and port name.
    RESULT_HTCS_EVENT_HANDLE_ALREADY_REGISTERED,   // The specified event handle for HTCS updates has already been registered.
    RESULT_HTCS_EVENT_HANDLE_NOT_FOUND,            // The specified event handle for HTCS updates has not been registered.
    RESULT_INVALID_TARGET_NAME,                    // Invalid target name.
    RESULT_PROGRAM_EVENT_HANDLE_ALREADY_REGISTERED,// The specified event handle for HTCS updates has already been registered.
    RESULT_INVALID_WORKING_DIRECTORY,              // Invalid working directory specified.

    RESULT_GENERIC_RANGE_END                    = 100,

    RESULT_PROCESS_RANGE_BEGIN                  = RESULT_GENERIC_RANGE_END,
    RESULT_PROCESS_START_FAILED,                // Failed to StartProcess.
    RESULT_PROCESS_NOT_LOADED,                  // Data has not finished loading.
    RESULT_PROCESS_INVALID_ARGUMENTS,           // Invalid process arguments.
    RESULT_PROCESS_CREATE_FAILED,               // Failed to create a process with path.
    RESULT_PROCESS_IS_RUNNING,                  // Process already running.
    RESULT_PROCESS_NOT_RUNNING,                 // Desired Process is not running.
    RESULT_PROCESS_NOT_HALTED,                  // Process not halted.
    RESULT_PROCESS_ALREADY_STARTED,             // Process already started.
    RESULT_PROCESS_HALTED,                      // Process halted.
    RESULT_PROCESS_UNKNOWN_REGISTER,            // Unknown register.
    RESULT_PROCESS_ATTACH_FAILED,               // Failed to attach to a process by program Id.
    RESULT_PROCESS_NOT_STARTED,                 // Process hasn't been started yet.
    RESULT_PROCESS_DEBUGGING_DISABLED,          // Debugging is disabled for this process.
    RESULT_PROCESS_PACKAGE_INCOMPLETE,          // A file is missing from the EXE.

    // Launch errors
    RESULT_PROCESS_APP_RECORD_NOT_FOUND,        // An internal error occurred: nn::ns::ResultApplicationRecordNotFound().
    RESULT_PROCESS_NO_SHELL_INFO,               // An internal error occurred: nn::ns::ResultNoShellInfo().
    RESULT_PROCESS_ALREADY_OCCUPIED,            // An internal error occurred: nn::ns::ResultAlreadyOccupied().
    RESULT_PROCESS_COMMUNICATION_FAILED,        // An internal error occurred: nn::ns::ResultCommunicationFailed().
    RESULT_PROCESS_SESSION_ALLOCATION_FAILED,   // An internal error occurred: nn::ns::ResultSessionObjectAllocationFailure().
    RESULT_PROCESS_MAIN_NOT_FOUND,              // An internal error occurred: nn::ns::ResultMainApplicationNotFound().
    RESULT_PROCESS_DOWNLOAD_PROBLEM,            // An internal error occurred: nn::ns::ResultAlreadyDownloading(), nn::ns::ResultApplicationNotDownloading(), nn::ns::ResultApplicationDownloadNotResumable().
    RESULT_PROCESS_META_CONTENT_NOT_FOUND,      // An internal error occurred: nn::ns::ResultContentMetaNotFound(), nn::ns::ResultNoContentMetaInApplicationRecord().
    RESULT_PROCESS_UPDATE_SYSTEM,               // An internal error occurred: nn::ns::ResultSystemUpdateRequired().
    RESULT_PROCESS_LAUNCH_RIGHTS_NOT_FOUND,     // An internal error occurred: nn::ns::ResultApplicationLaunchRightsNotFound().
    RESULT_PROCESS_ACCOUNT_PROBLEM,             // An internal error occurred: nn::ns::ResultInactiveNintendoAccount().
    RESULT_PROCESS_EULA_PROBLEM,                // An internal error occurred: nn::ns::ResultEulaSystemDataNotFound(), nn::ns::ResultEulaDataPathNotFound().
    RESULT_PROCESS_LOGO_PROBLEM,                // An internal error occurred: nn::ns::ResultLogoPartitionNotFound(), nn::ns::ResultLogoPathNotFound().
    RESULT_PROCESS_SD_PROBLEM,                  // An internal error occurred: nn::ns::ResultSdCardNoOwnership(), nn::ns::ResultSdCardNeedsSystemUpdate(), nn::ns::ResultSdCardFileSystemCorrupted().
    RESULT_PROCESS_STORAGE_PROBLEM,             // An internal error occurred: nn::ns::ResultStorageAccessFailed().
    RESULT_PROCESS_META_PROBLEM,                // An internal error occurred: nn::ns::ResultSystemUpdateMetaKeyNotFound(), nn::ns::ResultSystemUpdateMetaContentNotFound().
    RESULT_PROCESS_CARD_PROBLEM,                // An internal error occurred: nn::ns::ResultCardUpdateNotSetup(), nn::ns::ResultCardUpdateNotPrepared(), nn::ns::ResultCardUpdateAlreadySetup().
    RESULT_PROCESS_LANGUAGE_PROBLEM,            // An internal error occurred: nn::ns::ResultApplicationLanguageNotFound().
    RESULT_PROCESS_CONTENT_PROBLEM,             // An internal error occurred: nn::ns::ResultOutOfMaxContentMetaKey().
    RESULT_PROCESS_CONTROL_PROBLEM,             // An internal error occurred: nn::ns::ResultApplicationControlDataNotFound().
    RESULT_PROCESS_PATCH_PROBLEM,               // An internal error occurred: nn::ns::ResultStorageAccessFailed().
    RESULT_PROCESS_APPLET_LAUNCH_DISABLED,      // An internal error occurred: nn::ns::ResultLaunchSystemAppletDisabled(), nn::ns::ResultLaunchOverlayAppletDisabled().

    RESULT_PROCESS_MODULE_DEBUG_OUT_OF_DATE,    // Module debug data is out of date.

    RESULT_PROCESS_FIRMWARE_UPDATE_REQUIRED,

    // Insert new codes above here.
    RESULT_PROCESS_RANGE_END
};

//------------------------------------------------------------------------------
} // namespace tmapi
//==============================================================================
