﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../tmipc/tmipc_defines.h"
#include "../tmipc/tmipc_packet.h"
#include "../tmipc/tmipc_task.h"

//==============================================================================
namespace tma { namespace threadfrozen {
//==============================================================================

enum Mode : s32
{
    UNKNOWN,
    SET,
    GET,
};

class Task : public tmipc::Task
{
public:
    explicit    Task();
               ~Task();

virtual void    OnInitiate  ( tmipc::Packet*    pPacket );
virtual void    OnRecvPacket( tmipc::Packet*    pPacket );
virtual void    OnSendPacket( tmipc::Packet*    pPacket );

private:

        void    HandleSet( void );
        void    HandleGet( void );

        bool    m_Success;
        Mode    m_TaskMode;
        u64     m_ThreadId;
        u8      m_Frozen;
        u8      m_Value;
};

//==============================================================================
}}
//==============================================================================
