﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "thread_frozen_api.h"
#include "thread_frozen_task.h"

//==============================================================================
namespace tma { namespace threadfrozen {
//==============================================================================

//==============================================================================

Task::Task()
: m_Success( false )
, m_TaskMode( Mode::UNKNOWN )
, m_Value( false )
{
    m_TaskType = tmipc::TaskType_ThreadFrozenTask;
}

//==============================================================================

Task::~Task()
{
}

//==============================================================================

void Task::OnInitiate( tmipc::Packet* pPacket )
{
    s32 Length = 0;
    s32 Mode = (s32)tma::threadfrozen::Mode::UNKNOWN;
    pPacket->ReadS32( Mode );
    pPacket->ReadU64( m_ThreadId );
    pPacket->ReadU8( m_Frozen );
    m_TaskMode = static_cast<tma::threadfrozen::Mode>( Mode );

    switch( m_TaskMode )
    {
        case tma::threadfrozen::Mode::SET:
            HandleSet();
            break;
        case tma::threadfrozen::Mode::GET:
            HandleGet();
            break;
        default:
            break;
    }
}

//==============================================================================

void Task::OnRecvPacket( tmipc::Packet* pPacket )
{
    ASSERT(0);
}

//==============================================================================

void Task::OnSendPacket( tmipc::Packet* pPacket )
{
    pPacket->WriteS32( (s32)m_TaskMode );
    pPacket->WriteU8( m_Success ); // operation status
    switch( m_TaskMode )
    {
        case Mode::GET:
            pPacket->WriteU8( m_Value );
            break;
        default:
            break;
    }

    Complete();
}

//==============================================================================

void Task::HandleSet()
{
    m_Success = SetThreadFrozen( m_ThreadId, m_Frozen );
}

//==============================================================================

void Task::HandleGet()
{
    m_Success = GetThreadFrozen( m_ThreadId, *(bool*)&m_Value );
}

//==============================================================================
}}
//==============================================================================
