﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../tmipc/tmipc_defines.h"
#include "../tmipc/tmipc_packet.h"
#include "../tmipc/tmipc_task.h"

//==============================================================================
namespace tma { namespace threadfrozen {
//==============================================================================

    bool SetThreadFrozen( u64 ThreadId, bool Frozen );
    bool GetThreadFrozen( u64 ThreadId, bool& Frozen );
    nn::Bit64* GetFrozenThreadIds( nn::Bit32& Size );
    void ClearThreadFrozen( u64 ThreadId );
    void ClearAllThreadFrozen();

//==============================================================================
}}
//==============================================================================
